#if !defined(AFX_WRITE_GRAPH_H__AD4CB8A0_D0DA_11D2_BDFF_B4F11F5CEB0D__INCLUDED_)
#define AFX_WRITE_GRAPH_H__AD4CB8A0_D0DA_11D2_BDFF_B4F11F5CEB0D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "error.h"
#include "resultdata.h"
#include "demodata.h"
#include "graph_tga.h"
#include "msglog.h"
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>

class write_graph  
{
private:
	graph_tga graph;
	double scale;
	double get_Q2_coord(double Q2_coord, double min, double max);
	double max_x;
	double max_y;
	double max_z;
	double min_x;
	double min_y;
	double min_z;
	void mywrite (int log, char* buf);
public:
	int* get_rgb (int part, int whole);
	void write (char* pathstr);
	void build (int x_size, int y_size);
	void calculate_max_values(demodata_t* data);
	void kills_per_time (demodata_t* pos, resultdata* result);
	unsigned int ksd_distribution (demodata_t* pos);
	unsigned int player_ways (demodata_t* pos, int* color_low, int* color_high);
	write_graph();
	virtual ~write_graph();

};

#endif // !defined(AFX_WRITE_GRAPH_H__AD4CB8A0_D0DA_11D2_BDFF_B4F11F5CEB0D__INCLUDED_)
